//	AUTHOR:			Maria Karmeliuk, Martin Kocher, Georg Schmidt
//	CREATED:		25/07/2022
//	MODIFIED: 		29/07/2022, by Georg Schmidt
//	DESCRIPTION:	This do-file replicates all results and figures in manuscript #EXEX-D-21-00039R1
//	INSTALL:		To be installed:

// Set Stata version
version
clear all

// Date last run (yyyymmdd)
local daterun 20220729

// Assign globals to dirs
global root ".../REPLICATION_PACKAGE/stata" //Change respectively
cd "$root"





**************************** REGRESSION TABLES ****************************


******************************** A.1 First-Price Auction

clear
use auctions_14_team
drop if part>1
xtset unique_id Period

***Table 2: Profits in FPA
eststo clear
eststo: quietly xi: xtreg NetProfit i.individual if auction_type==1, re vce(cluster MGroup)
eststo: quietly xi: xtreg NetProfit i.individual invest if auction_type==1, re vce(cluster MGroup)
eststo: quietly xi: xtreg NetProfit invest i.individual*Period  if auction_type==1, re vce(cluster MGroup)
eststo: quietly xi: xtreg NetProfit i.individual*Period delta_sp invest num_correct if auction_type==1, re vce(cluster MGroup)
eststo: quietly xi: xtreg NetProfit i.individual*Period delta_sp invest num_correct experience gender if auction_type==1, re vce(cluster MGroup)
eststo: quietly xi: xtreg NetProfit i.individual*Period delta_sp i.individual*invest i.individual*num_correct experience gender if auction_type==1, re vce(cluster MGroup)
esttab using reg_table.tex, label replace booktabs compress interaction(" * ") se star(* 0.10 ** 0.05 *** 0.01) title(Profits in FPA) nomtitles stats(N r2_o, labels("Observations" "R^2"))

***Table 3: Bids in FPA
eststo clear
eststo: quietly xi: xtreg bid_fp_fin i.individual value if auction_type==1, re vce(cluster MGroup) 
eststo: quietly xi: xtreg bid_fp_fin i.individual*value if auction_type==1, re vce(cluster MGroup) 
eststo: quietly xi: xtreg bid_fp_fin i.individual*value i.individual*invest if auction_type==1, re vce(cluster MGroup)
eststo: quietly xi: xtreg bid_fp_fin i.individual*value i.individual*invest i.individual*Period if auction_type==1, re vce(cluster MGroup)
eststo: quietly xi: xtreg bid_fp_fin i.individual*value i.individual*invest i.individual*Period delta_sp i.individual*num_correct  if auction_type==1, re vce(cluster MGroup)
eststo: quietly xi: xtreg bid_fp_fin i.individual*value i.individual*invest i.individual*Period delta_sp i.individual*num_correct gender experience  if auction_type==1, re vce(cluster MGroup)
esttab using reg_table.tex, label replace booktabs compress interaction(" * ") se star(* 0.10 ** 0.05 *** 0.01) title(Bids in FPA) nomtitles stats(N r2_o, labels("Observations" "R^2"))

***Table 4: Prices in FPA
clear
use auctions_14_market
drop if part>1
xtset unique_id_mrkt Period
eststo clear
eststo: quietly xi: xtreg price individual max_value second_value if auction_type==1, re vce(cluster MGroup)
eststo: quietly xi: xtreg price i.individual*max_value i.individual*second_value if auction_type==1, re vce(cluster MGroup)
eststo: quietly xi: xtreg price i.individual*max_value i.individual*second_value i.individual*invest if auction_type==1, re vce(cluster MGroup)
eststo: quietly xi: xtreg price i.individual*max_value i.individual*second_value i.individual*invest i.individual*Period if auction_type==1, re vce(cluster MGroup)
eststo: quietly xi: xtreg price i.individual*max_value i.individual*second_value i.individual*invest i.individual*Period delta_sp i.individual*num_correct if auction_type==1, re vce(cluster MGroup)
eststo: quietly xi: xtreg price i.individual*max_value i.individual*second_value i.individual*invest i.individual*Period delta_sp i.individual*num_correct gender experience if auction_type==1, re vce(cluster MGroup) 
esttab using reg_table.tex, label replace booktabs compress interaction(" * ") se star(* 0.10 ** 0.05 *** 0.01) title(Prices in FPA) nomtitles stats(N r2_o, labels("Observations" "R^2"))


******************************** A.2 English Auction

clear
use auctions_14_team
drop if part>1
xtset unique_id Period

***Table 5: Profits in EA
eststo clear
eststo: quietly xi: xtreg NetProfit i.individual if auction_type==2, re vce(cluster MGroup)
eststo: quietly xi: xtreg NetProfit i.individual invest if auction_type==2, re vce(cluster MGroup)
eststo: quietly xi: xtreg NetProfit invest i.individual*Period  if auction_type==2, re vce(cluster MGroup)
eststo: quietly xi: xtreg NetProfit i.individual*Period delta_sp invest num_correct if auction_type==2, re vce(cluster MGroup)
eststo: quietly xi: xtreg NetProfit i.individual*Period delta_sp invest num_correct experience gender if auction_type==2, re vce(cluster MGroup)
eststo: quietly xi: xtreg NetProfit i.individual*Period delta_sp i.individual*invest i.individual*num_correct experience gender if auction_type==2, re vce(cluster MGroup)
esttab using reg_table.tex, label replace booktabs compress interaction(" * ") se star(* 0.10 ** 0.05 *** 0.01) title(Profits in EA) nomtitles stats(N r2_o, labels("Observations" "R^2"))

***Table 6: Prices in EA
clear
use auctions_14_market
drop if part>1
xtset unique_id_mrkt Period
eststo clear
eststo: quietly xi: xtreg price individual max_value second_value if auction_type==2, re vce(cluster MGroup) 
eststo: quietly xi: xtreg price i.individual*max_value i.individual*second_value if auction_type==2, re vce(cluster MGroup) 
eststo: quietly xi: xtreg price i.individual*max_value i.individual*second_value i.individual*invest if auction_type==2, re vce(cluster MGroup)
eststo: quietly xi: xtreg price i.individual*max_value i.individual*second_value i.individual*invest i.individual*Period if auction_type==2, re vce(cluster MGroup)
eststo: quietly xi: xtreg price i.individual*max_value i.individual*second_value i.individual*invest i.individual*Period delta_sp i.individual*num_correct if auction_type==2, re vce(cluster MGroup)
eststo: quietly xi: xtreg price i.individual*max_value i.individual*second_value i.individual*invest i.individual*Period delta_sp i.individual*num_correct gender experience if auction_type==2, re vce(cluster MGroup) 
esttab using reg_table.tex, label replace booktabs compress interaction(" * ") se star(* 0.10 ** 0.05 *** 0.01) title(Prices in EA) nomtitles stats(N r2_o, labels("Observations" "R^2"))


******************************** A.3 Emotions

clear
use auctions_14_ind.dta
drop if part>1
drop if auction_type==2
xtset unique_id Period

***Table 7: Emotions associated with winning an auction
eststo clear
eststo: quietly xi: xtreg Neutral i.individual*winner, re vce(cluster MGroup)
eststo: quietly xi: xtreg Happy i.individual*winner, re vce(cluster MGroup)
eststo: quietly xi: xtreg Sad i.individual*winner, re vce(cluster MGroup)
eststo: quietly xi: xtreg Angry i.individual*winner, re vce(cluster MGroup)
esttab using reg_table.tex, label replace booktabs compress interaction(" * ") se star(* 0.10 ** 0.05 *** 0.01) title(Emotions associated with winning an auction) nomtitles stats(N r2_o, labels("Observations" "$R^2$"))
eststo clear
eststo: quietly xi: xtreg Surprised i.individual*winner, re vce(cluster MGroup)
eststo: quietly xi: xtreg Scared i.individual*winner, re vce(cluster MGroup)
eststo: quietly xi: xtreg Disgusted i.individual*winner, re vce(cluster MGroup)
eststo: quietly xi: xtreg Valence i.individual*winner, re vce(cluster MGroup)
esttab using reg_table.tex, label replace booktabs compress interaction(" * ") se star(* 0.10 ** 0.05 *** 0.01) title(Emotions associated with winning an auction) nomtitles stats(N r2_o, labels("Observations" "$R^2$"))

***Table 8: The effect of emotions on future bids
sort session unique_id Period
gen Valence_lag1=Valence[_n-1] if unique_id==unique_id[_n-1]
gen Neutral_lag1=Neutral[_n-1] if unique_id==unique_id[_n-1]
gen Happy_lag1=Happy[_n-1] if unique_id==unique_id[_n-1]
gen Sad_lag1=Sad[_n-1] if unique_id==unique_id[_n-1]
gen Angry_lag1=Angry[_n-1] if unique_id==unique_id[_n-1]
gen Surprised_lag1=Surprised[_n-1] if unique_id==unique_id[_n-1]
gen Scared_lag1=Scared[_n-1] if unique_id==unique_id[_n-1]
gen Disgusted_lag1=Disgusted[_n-1] if unique_id==unique_id[_n-1]
gen winner_lag1 = winner[_n-1] if unique_id==unique_id[_n-1]
gen mood1_lag1 = mood1[_n-1] if unique_id==unique_id[_n-1]
gen mood2_lag1 = mood2[_n-1] if unique_id==unique_id[_n-1]
gen NetProfit_lag1 = NetProfit[_n-1] if unique_id==unique_id[_n-1]
eststo clear
eststo: quietly xi: xtreg bid_fp_fin i.individual*value, re vce(cluster MGroup)
eststo: quietly xi: xtreg bid_fp_fin i.individual*value i.individual*invest, re vce(cluster MGroup)
eststo: quietly xi: xtreg bid_fp_fin i.individual*value i.individual*invest i.individual*Period winner_lag1, re vce(cluster MGroup)
eststo: quietly xi: xtreg bid_fp_fin i.individual*value i.individual*invest i.individual*Period winner_lag1 delta_sp num_correct, re vce(cluster MGroup)
eststo: quietly xi: xtreg bid_fp_fin i.individual*value i.individual*invest i.individual*Period i.winner_lag1*Sad_lag1 delta_sp num_correct Neutral_lag1 Happy_lag1 Angry_lag1 Surprised_lag1 Scared_lag1 Disgusted_lag1, re vce(cluster MGroup)
esttab using reg_table.tex, label replace booktabs compress interaction(" * ") se star(* 0.10 ** 0.05 *** 0.01) title(The effect of emotions on future bids) nomtitles stats(N r2_o, labels("Observations" "R^2"))


******************************** C.1 Additional Tables First-Price Auction

clear
use auctions_14_team
drop if part>1
xtset unique_id Period

***Table 9: Profits relative to value in FPA
eststo clear
eststo: quietly xi: xtreg rel_NetProfit i.individual if auction_type==1, re vce(cluster MGroup)
eststo: quietly xi: xtreg rel_NetProfit i.individual invest if auction_type==1, re vce(cluster MGroup)
eststo: quietly xi: xtreg rel_NetProfit invest i.individual*Period if auction_type==1, re vce(cluster MGroup)
eststo: quietly xi: xtreg rel_NetProfit i.individual*Period delta_sp invest num_correct if auction_type==1, re vce(cluster MGroup)
*REV no mathgrade
eststo: quietly xi: xtreg rel_NetProfit i.individual*Period delta_sp invest num_correct experience gender if auction_type==1, re vce(cluster MGroup)
*REV adding interactions
eststo: quietly xi: xtreg rel_NetProfit i.individual*Period delta_sp i.individual*invest i.individual*num_correct experience gender if auction_type==1, re vce(cluster MGroup)
esttab using reg_table.tex, label replace booktabs compress interaction(" * ") se star(* 0.10 ** 0.05 *** 0.01) title(Relative Profits in FPA) nomtitles stats(N r2_o, labels("Observations" "R^2"))

***Table 10: Bid shading in FPA
eststo clear
eststo: quietly xi: xtreg delta_bid i.individual value if auction_type==1, re vce(cluster MGroup) 
eststo: quietly xi: xtreg delta_bid i.individual*value if auction_type==1, re vce(cluster MGroup) 
eststo: quietly xi: xtreg delta_bid i.individual*value i.individual*invest if auction_type==1, re vce(cluster MGroup)
eststo: quietly xi: xtreg delta_bid i.individual*value i.individual*invest i.individual*Period if auction_type==1, re vce(cluster MGroup)
eststo: quietly xi: xtreg delta_bid i.individual*value i.individual*invest i.individual*Period delta_sp i.individual*num_correct  if auction_type==1, re vce(cluster MGroup)
eststo: quietly xi: xtreg delta_bid i.individual*value i.individual*invest i.individual*Period delta_sp i.individual*num_correct gender experience  if auction_type==1, re vce(cluster MGroup)
esttab using reg_table.tex, label replace booktabs compress interaction(" * ") se star(* 0.10 ** 0.05 *** 0.01) title(Bids in FPA) nomtitles stats(N r2_o, labels("Observations" "R^2"))


******************************** C.2 Additional Tables English Auction

***Table 11: Bids in EA
eststo clear
eststo: quietly xi: xtreg maxbid_ea i.individual max_value second_value if auction_type==2, re vce(cluster MGroup) 
eststo: quietly xi: xtreg maxbid_ea i.individual*max_value i.individual*second_value if auction_type==2, re vce(cluster MGroup) 
eststo: quietly xi: xtreg maxbid_ea i.individual*max_value i.individual*second_value i.individual*invest if auction_type==2, re vce(cluster MGroup)
eststo: quietly xi: xtreg maxbid_ea i.individual*max_value i.individual*second_value i.individual*invest i.individual*Period  if auction_type==2, re vce(cluster MGroup)
eststo: quietly xi: xtreg maxbid_ea i.individual*max_value i.individual*second_value i.individual*invest i.individual*Period delta_sp i.individual*num_correct  if auction_type==2, re vce(cluster MGroup)
eststo: quietly xi: xtreg maxbid_ea i.individual*max_value i.individual*second_value i.individual*invest i.individual*Period delta_sp i.individual*num_correct gender experience  if auction_type==2, re vce(cluster MGroup)
esttab using reg_table.tex, label replace booktabs compress interaction(" * ") se star(* 0.10 ** 0.05 *** 0.01) title(Bids in EA) nomtitles stats(N r2_o, labels("Observations" "R^2"))





********************************* GRAPHS **********************************


******************************** Main Body

clear
use auctions_14_mg

***Figure 1: Profits earned by bidders
*(a) First-price auction, average
graph bar NetProfit if auction_type==1, over(treatment, relabel(1 "Individuals" 2 "Teams")) bar(1, fcolor(gs12) lcolor(gs0)) graphregion(color(none)) ytitle("Profit in FPA") ylabel(0(1)7)
*(b) English auction, average
graph bar NetProfit if auction_type==2, over(treatment, relabel(1 "Individuals" 2 "Teams")) bar(1, fcolor(gs12) lcolor(gs0)) graphregion(color(none)) ytitle("Profit in EA") ylabel(0(1)7)
*(c) First-price auction, by period
clear
use auctions_14_team
sort Period
line MProfit_ind_fpa MProfit_team_fpa Period if part==1, xlabel(1/12) legend(label(1 "Individuals") label(2 "Teams") region(style(none))) graphregion(color(none)) lcolor(black black) lpattern(longdash solid)  ytitle("Profit in FPA")  ylabel(-3(2)11)
*(d) English auction, by period
line MProfit_ind_ea MProfit_team_ea Period if part==1 & Period<=8, xlabel(1/8) legend(label(1 "Individuals") label(2 "Teams") region(style(none))) graphregion(color(none)) lcolor(black black) lpattern(longdash solid)  ytitle("Profit in EA") ylabel(-3(2)11)

***Figure 2: Bid shading in first-price auctions
*(a) Average
clear
use auctions_14_mg
graph bar delta_bid if auction_type==1, over(treatment, relabel(1 "Individuals" 2 "Teams")) bar(1, fcolor(gs12) lcolor(gs0)) graphregion(color(none)) ytitle("Bid shading in FPA") ylabel(0(5)20)
*(b) By period
clear
use auctions_14_team
sort Period
line MShad_ind_fpa MShad_team_fpa Period if part==1, xlabel(1/12) legend(label(1 "Individuals") label(2 "Teams") region(style(none))) graphregion(color(none)) lcolor(black black) lpattern(longdash solid)  ytitle("Bid shading in FPA")  ylabel(0(5)20)

***Figure 3: Deviation from predicted bid shading in first-price auctions
*(a) Average
graph bar MeanShadPred MeanShad if auction_type==1, over(treatment, relabel(1 "Individuals" 2 "Teams")) bar(1, fcolor(gs12) lcolor(gs0)) bar(2, fcolor(gs6) lcolor(gs0)) graphregion(color(none)) ytitle("Predicted vs. real bid shading in FPA") legend(label(1 "Predicted") label(2 "Real") region(style(none)))
*(b) By period
line MShadPred_ind_fpa MShad_ind_fpa MShadPred_team_fpa MShad_team_fpa Period if part==1, xlabel(1/12) legend(label(1 "predicted IND") label(2 "real IND") label(3 "predicted TEAM") label(4 "real TEAM") region(style(none))) graphregion(color(none)) lcolor(gs12 black gs12 black) lpattern(longdash longdash solid solid)  ytitle("Predicted vs. real bid shading in FPA")  ylabel(0(5)20)

***Figure 4: Realized prices
*(a) First-price auction, average
clear
use auctions_14_mg
graph bar price if auction_type==1, over(treatment, relabel(1 "Individuals" 2 "Teams")) bar(1, fcolor(gs12) lcolor(gs0)) graphregion(color(none)) ytitle("Prices in FPA") ylabel(0(10)70)
*(b) English auction, average
graph bar price if auction_type==2, over(treatment, relabel(1 "Individuals" 2 "Teams")) bar(1, fcolor(gs12) lcolor(gs0)) graphregion(color(none)) ytitle("Prices in EA") ylabel(0(10)70)
*(c) First-price auction, by period
clear
use auctions_14_team
sort Period
line MPrice_ind_fpa MPrice_team_fpa Period if part==1, xlabel(1/12) legend(label(1 "Individuals") label(2 "Teams") region(style(none))) graphregion(color(none)) lcolor(black black) lpattern(longdash solid)  ytitle("Prices in FPA")  ylabel(35(5)75)
*(d) English auction, by period
line MPrice_ind_ea MPrice_team_ea Period if part==1 & Period<=8, xlabel(1/8) legend(label(1 "Individuals") label(2 "Teams") region(style(none))) graphregion(color(none)) lcolor(black black) lpattern(longdash solid)  ytitle("Prices in EA")  ylabel(35(5)75)

***Figure 5: Valence of the emotions experienced by the subjects seeing their feedback screens in FPA treatments
clear
use auctions_14_mg
drop if auction_type==2
graph bar Valence, over(treatment, relabel(1 "Individuals" 2 "Teams")) bar(1, fcolor(gs12) lcolor(gs0)) graphregion(color(none)) ytitle("Valence in FPA") yline(0, lcolor(black))

***Figure 6: Absolute deviation from rational strategy (value minus bid) in SPA
clear
use auctions_14_mg
graph bar delta_sp, over(individual, relabel(2 "Individuals" 1 "Teams")) over(auction_type, relabel(1 "FPA treatments" 2 "EA treatments")) graphregion(color(none)) ytitle("Error in SPA") bar(1, fcolor(gs12) lcolor(gs0))

***Figure 7: Proposed and final bid shading in first-price auctions
*(a) Average
clear
use auctions_14_team
sort Period
graph bar delta_bid_proposal delta_bid if auction_type==1, over (treatment, relabel(1 "Individuals" 2 "Teams")) bar(1, fcolor(gs12) lcolor(gs0)) bar(2, fcolor(gs6) lcolor(gs0)) graphregion(color(none)) ytitle("Bid shading in FPA") legend(label(1 "First proposal") label(2 "Final choice") region(style(none)))
*(b) By period
line MShadProp_ind_fpa MShad_ind_fpa MShadProp_team_fpa MShad_team_fpa Period if part==1, xlabel(1/12) legend(label(1 "proposal IND") label(2 "final IND") label(3 "proposal TEAM") label(4 "final TEAM") region(style(none))) graphregion(color(none)) lcolor(gs12 black gs12 black) lpattern(longdash longdash solid solid)  ytitle("Bid shading in FPA") ylabel(0(5)15)


******************************** C.3 Team Decision Making

///////Generating additional variables
	*excluding immediate consensus teams
	clear
	use contracts_14.dta
	drop if part!=1
	sort session part Period Team Subject bid_number
	*team mean/median of first proposals
	by session Period part Team, sort : egen float bid_fp_prop_mu = mean(bid_fp) if bid_number==1
	by session Period part Team, sort : egen float bid_fp_prop_p50 = median(bid_fp) if bid_number==1
	*first proposals in teams
	sort session part Period Team bid_number bid_fp
	bysort session part Period Team bid_number: gen bid_fp_prop_low = bid_fp[1] if bid_number == 1
	bysort session part Period Team bid_number: gen bid_fp_prop_med = bid_fp[2] if bid_number == 1
	bysort session part Period Team bid_number: gen bid_fp_prop_high = bid_fp[3] if bid_number == 1
	*final proposals in teams
	bysort session part Period Team TeamID (bid_number): gen bid_fp_prop_last = bid_fp[_N]
	*change (instant consensus)
	by session part Period Team bid_number bid_fp, sort: gen nvals = _n == 1 if bid_number == 1
	by session part Period Team bid_number: replace nvals = sum(nvals) if bid_number == 1
	by session part Period Team bid_number: replace nvals = nvals[_N] if bid_number == 1
	gen bid_fp_prop_1_consens = 0
	replace bid_fp_prop_1_consens = 1 if (nvals == 1 & auction_type == 1)
	drop nvals
	*consens
	by session part Period Team bid_fp_prop_last, sort: gen nvals = _n == 1
	by session part Period Team: replace nvals = sum(nvals)
	by session part Period Team: replace nvals = nvals[_N]
	gen bid_fp_consens = 0
	replace bid_fp_consens = 1 if (nvals == 1 & auction_type == 1)
	drop nvals
	*team decision-making process
	drop if auction_type == 2
	collapse auction_type bid_fp_prop_low bid_fp_prop_med bid_fp_prop_high bid_fp_prop_last bid_fp_prop_mu bid_fp_prop_p50 bid_fp_prop_1_consens bid_fp_consens, by(session part Period Team)
	tab bid_fp_consens bid_fp_prop_1_consens
	gen bid_fp_revision_mu = bid_fp_prop_last - bid_fp_prop_mu
	gen bid_fp_revision_p50 = bid_fp_prop_last - bid_fp_prop_p50
	sort bid_fp_prop_med bid_fp_prop_low bid_fp_prop_high
	gen unique_id_team = session*10 + Team
	gen unique_id_team_Period = unique_id_team + (Period / 100)
	gen unique_id = session*100 + Team
	gen bid_fp_prop_1_spread = bid_fp_prop_high - bid_fp_prop_low
///////	
	
***Figure 8: Distribution of spreads between lowest and highest bid proposal
histogram bid_fp_prop_1_spread, discrete width(5) start(0) graphregion(margin(small) color(white)) bgcolor(none) legend(region(style(none))) xtitle(Spread lowest to highest bid proposal within team) fcolor(gs12) lcolor(gs0)
mean bid_fp_prop_1_spread
	
***Figure 9: Deviation of final bidding agreement
*(a) Median of initial proposals
histogram bid_fp_revision_p50, discrete width(4) graphregion(margin(small) color(white)) bgcolor(none) legend(region(style(none))) xtitle(Revision to median proposal) fcolor(gs12) lcolor(gs0)
mean bid_fp_revision_p50
*(b) Mean of initial proposals
histogram bid_fp_revision_mu, discrete width(4) graphregion(margin(small) color(white)) bgcolor(none) legend(region(style(none))) xtitle(Revision to average proposal) fcolor(gs12) lcolor(gs0)
mean bid_fp_revision_mu

///////Generating additional variables
	clear
	use contracts_14.dta
	drop if part!=3
	sort session part Period Team unique_id_ind
	*team mean/median of first proposals
	by session Period part Team, sort : egen float invest_prop_mu = mean(invest) if invest_number==1
	by session Period part Team, sort : egen float invest_prop_p50 = median(invest) if invest_number==1
	*first proposals in teams
	sort session Period part Team invest_number invest
	bysort session Period part Team invest_number: gen invest_prop_low = invest[1] if invest_number == 1
	bysort session Period part Team invest_number: gen invest_prop_med = invest[2] if invest_number == 1
	bysort session Period part Team invest_number: gen invest_prop_high = invest[3] if invest_number == 1
	*final proposals in teams
	bysort session Period part Team TeamID (invest_number): gen invest_last = invest[_N]
	*consens
	by session Period part Team invest_last, sort: gen nvals = _n == 1
	by session Period part Team: replace nvals = sum(nvals)
	by session Period part Team: replace nvals = nvals[_N]
	gen invest_consens = 0
	replace invest_consens = 1 if nvals == 1
	drop nvals
	collapse invest_prop_low invest_prop_med invest_prop_high invest_last invest_prop_mu invest_prop_p50 invest_consens, by(session part Period Team)
	gen invest_revision_mu = invest_last - invest_prop_mu
	gen invest_revision_p50 = invest_last - invest_prop_p50
	sort invest_prop_med invest_prop_low invest_prop_high
	gen unique_id_team = session*10 + Team
	gen auction_type = 0
	replace auction_type = 1 if session == 2 | session == 8 | session == 10 | session == 11 | session == 13
///////

***Figure 10: Initial investment proposals in teams	
*(a) FPA
graph dot (asis) invest_prop_low invest_prop_med invest_prop_high if(auction_type==0), over(unique_id_team, sort(invest_prop_med invest_prop_low) label(nolabel)) extendline linetype(line) lines(lwidth(vthin)) aspectratio(1) graphregion(margin(small) color(white)) bgcolor(none) legend(off)
*(b) EA
graph dot (asis) invest_prop_low invest_prop_med invest_prop_high if(auction_type==1), over(unique_id_team, sort(invest_prop_med invest_prop_low) label(nolabel)) extendline linetype(line) lines(lwidth(vthin)) aspectratio(1) graphregion(margin(small) color(white)) bgcolor(none) legend(off)

***Figure 11: Deviation of final investment decision
*(a) Median of initial proposals
hist invest_revision_p50, discrete width(10) graphregion(margin(small) color(white)) bgcolor(none) legend(region(style(none))) xtitle(Revision to median proposal) fcolor(gs12) lcolor(gs0) yscale(range(0.05)) xscale(range(-50 100)) xlabel(-40(20)100) ylabel(0(0.01)0.05)
*(b) Mean of initial proposals
hist invest_revision_mu, discrete width(10) graphregion(margin(small) color(white)) bgcolor(none) legend(region(style(none))) xtitle(Revision to mean proposal) fcolor(gs12) lcolor(gs0) yscale(range(0.05)) xscale(range(-50 100)) xlabel(-40(20)100) ylabel(0(0.01)0.05)





********************** DESCRIPTIVES, TEST STATISTICS **********************


******************************** 3 Results

clear
use auctions_14_mg

*** 3.1 Realized profits
*FPA
mean NetProfit if auction_type==1, over(treatment)
ranksum NetProfit if auction_type==1, by(treatment)
*EA
mean NetProfit if auction_type==2, over(treatment)
ranksum NetProfit if auction_type==2, by(treatment)

*** 3.2 Bidding behavior
*FPA
mean bid_fp_fin, over(treatment)
mean delta_bid if auction_type==1, over(treatment)
ranksum delta_bid if auction_type==1, by(treatment)
*FPA Predicted optimal bids
clear
use auctions_14_team
mean risk_par_r if auction_type==1, over(treatment)
mean risk_par_r if auction_type==1 & invest>0, over(treatment)
clear
use auctions_14_mg
ranksum risk_par_r if auction_type==1, by(treatment)
clear
use auctions_14_team
mean MeanShadPred MeanShad if auction_type == 1, over(treatment)
clear
use auctions_14_mg
mean bid_fp_diff if auction_type == 1, over(treatment)
ranksum bid_fp_diff if auction_type==1, by(treatment)
*EA length of stay
mean stay_ea if auction_type==2, over(treatment)
ranksum stay_ea if auction_type==2, by(treatment)
*EA relative bid
mean mean_rbid_ea if auction_type==2, over(treatment)
ranksum mean_rbid_ea if auction_type==2, by(treatment)

*** 3.3 Market outcomes: prices and efficiency
mean price if auction_type==1, over(treatment) 
ranksum price if auction_type==1, by(treatment)
*Efficiency
mean efficiency if auction_type==1, over(treatment)
ranksum efficiency if auction_type==1, by(treatment)
mean efficiency if auction_type==2, over(treatment)
ranksum efficiency if auction_type==2, by(treatment)

*** 3.4 Emotions
ranksum Valence if auction_type==1, by(treatment)


******************************** 4 Further analyses and discussion

clear
use auctions_14_mg

*SPA Differences
mean delta_sp, over(individual auction_type)
ranksum delta_sp if auction_type==1, by(individual)
ranksum delta_sp if auction_type==2, by(individual)
*Consens
*	see above in generating additional variables for C.3 Team Decision Making
*		tab bid_fp_consens bid_fp_prop_1_consens
*Risk heterogeneity
clear
use auctions_14_team
tabstat invest, by(individual) statistics(variance)
tabstat invest if auction_type==1, by(individual) statistics(variance)
tabstat invest if auction_type==2, by(individual) statistics(variance)
hist invest if individual==1
hist invest if individual==0
*Realized prices
clear
use auctions_14_mg
mean price, over(auction_type)
ranksum price, by(auction_type) 


******************************** C.3 Team Decision Making

clear
use contracts_14.dta

*Contemplation FPA
drop if part > 1
drop if auction_type != 1
mean(TimeWeiterFPABlBidProposalMake) if (bid_number==1 & TimeWeiterFPABlBidProposalMake >= 0)
by session Period part Team, sort : egen bid_number_max = max(bid_number)
by session Period part Team, sort : egen TimeDiscuss = max(TimeBestaetige13) if bid_number_max > 1
replace TimeDiscuss = 0 if bid_number_max ==1
collapse TimeDiscuss, by(session part Period Team)
summarize(TimeDiscuss)
centile TimeDiscuss, centile(50)
hist TimeDiscuss
*Proposal spread
*	see above, right below code for Figure 8
*Revision from median or mean proposal
*	see above, right below code for Figures 9a and 9b



//	END OF REPLICATION
